//Dustin Soodak

//
//behavior 034:
//Look at accelerometer and gyroscope
//compare still to moving forward and record accel & gyro data to be spit out later
#include "MiscHardware.h"
#include "Navigation.h"
#include <math.h>
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
  
}
int accelx,accely,accelz,dir;
int i;
int accelraw[3];
int accelrawtemp[3];
int accel[3];
int gyroraw[3];
int gyro[3];
int32_t rawaccelsquared,accelsquared;
//
#define DAT_SIZE (380)
int dat[DAT_SIZE];
int datpos=0;
char motorson=0;
int32_t accelzero=0,gyrozero=0;
//
char ch;
String NumString="";
int motoroffset=0;

void loop(){
  SwitchPixelsToButton();    
  while(!ButtonPressed()){
    if(Serial.available() > 0){
      ch = Serial.read();    
      if (isDigit(ch) || ch=='-'){
        NumString += (char)ch;  
      }
      if(ch=='\n'){      
        motoroffset=NumString.toInt();//-25 works well for robot 1
        NumString="";
        Serial.println(motoroffset,DEC);
      }  
    }//end if(Serial.available() > 0)
  }
  Serial.println("starting");
  delay(1000);
  NavigationBegin();  
  RestartTimer();
  SwitchButtonToPixels();
  SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
  datpos=0;
  accelzero=0;
  gyrozero=0;
  motorson=0; 
  
  while(1){
    //SimpleNavigation();    
    if(GyroBufferSize()>0){//gyro is slower so this should also mean there is some accel data      
      GyroGetAxes(gyroraw);//380 hz 
      AccelGetAxes(accelraw);//400 hz
      if(AccelBufferSize()>0){//to keep buffers in sync
         AccelGetAxes(accelrawtemp);
         for(i=0;i<3;i++){
            accelraw[i]=(accelraw[i]+accelrawtemp[i])/2;
         }
      }      
      //
      if(datpos<DAT_SIZE){
        
        if(datpos<(DAT_SIZE>>1)){
          accelzero+=accelraw[1];
          gyrozero+=gyroraw[2];
        }
        else{
          dat[datpos]=accelraw[1];
          dat[datpos-(DAT_SIZE>>1)]=gyroraw[2];
        }
        datpos++;
        Serial.println(datpos);
      }
      if(motorson==0 && datpos==(DAT_SIZE>>1)){
        accelzero=accelzero/(DAT_SIZE>>1);
        gyrozero=gyrozero/(DAT_SIZE>>1);
        motorson=1;
        SwitchButtonToPixels();
        SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
        SwitchSerialToMotors();
        Motors(100+motoroffset,100-motoroffset); 
      }
      if(datpos==DAT_SIZE && motorson){
        motorson=0; 
        SwitchButtonToPixels();
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        SwitchSerialToMotors();
        Motors(0,0);        
      }      
    }//end if(GyroBufferSize()>0)
    
    //
    SwitchPixelsToButton(); 
    if(ButtonPressed()){
      Serial.println("zeroes: ");
      Serial.print(accelzero,DEC);
      Serial.print("\t");
      Serial.print(gyrozero,DEC);
      Serial.println();
      Serial.println("accel raw\tgyro raw");
      for(i=datpos/2;i<datpos;i++){
        Serial.print(dat[i],DEC);//accel
        Serial.print("\t");
        Serial.println(dat[i-datpos/2],DEC);//gyro
      }
      //
      break;
    }
    if(GetTime()>200 && datpos==DAT_SIZE){//
      rawaccelsquared=0;
      accelsquared=0;
      for(i=0;i<3;i++){
        accel[i]=accelraw[i]*(-(float)(2*9800)/32768);//range: 2g, g=9.8m/s^2
        rawaccelsquared+=((int32_t)accelraw[i])*((int32_t)accelraw[i]);
        accelsquared+=((int32_t)accel[i])*((int32_t)accel[i]);
        gyro[i]=-((float)gyroraw[i])*2000*0.0000355;
      }  
      //gyro:
      //range	calc dps/dig	"typ" in datasheet	to get to "typ"		
      //250	0.007629395	0.00875           	1.14687993         
      //500	0.015258789	0.0175           	1.146880005
      //2000	0.061035156	0.070            	1.146880005
      // 1/2^15*1.14688=exactly .000035          
      dir=90-atan2(accely,accelx)*180/3.14159;
      SwitchMotorsToSerial();
      Serial.print(accelraw[0],DEC);
      Serial.print(" ");
      Serial.print(accelraw[1],DEC);
      Serial.print(" ");
      Serial.print(accelraw[2],DEC);
      Serial.print(" dir ");
      Serial.println(dir,DEC);
      Serial.print(" ");
      Serial.print(accel[0],DEC);
      Serial.print(" ");
      Serial.print(accel[1],DEC);
      Serial.print(" ");
      Serial.print(accel[2],DEC);
      Serial.println();
      Serial.print(" raw amplitude ");
      Serial.print(sqrt(rawaccelsquared),DEC);
      Serial.print(" amplitude ");    
      Serial.print(sqrt(accelsquared),DEC);
      Serial.print(" gyro raw ");  
      Serial.print(gyroraw[2],DEC);
      Serial.print(" dps ");
      Serial.print(gyro[2],DEC);
      Serial.println();
      RestartTimer(); 
      //
      
    }
  }//end while(1)
  
}//end loop()

